/*Codice SAS per riprodurre la Loss di un portafoglio di crediti usando pd, ead, lgd senza correlazione di default*/

ods html close;
ods html;
/* generazione di default indipendenti */
proc iml;
N=10;
pd=.2;
nsim=1000;
call randseed(2000);
/* x contiene gli indicatori di default cio L in 0,1 caso  indipendende ro=0 */
x=j(nsim,n,.);
call randgen(x,'Bernoulli',pd);

/* definizione EAD (cioe E nel paper di Molins e Vives) */
/* caso: tutti gli EAD sono uguali */
ead=2;
xead=j(1,n,ead);
print xead; 
/* definizione LGD (cioe (1-RR)) */
/* caso: tutti gli LGD sono uguali */
lgd=0.8;
xlgd=j(1,n,lgd);
print xlgd; 
loss=j(nsim,1,0); /*inizializzo loss i=0*/
do i=1 to nrow(x);
	do j=1 to ncol(x);
		loss[i]=loss[i]+x[i,j]*xead[j]*xlgd[j];
	end;
end;
call histogram(loss);
